<?php
/**
 * Inspired from 
 * http://www.esup-portail.org/display/PROJDOCUWIKICAS/CASification+de+Docuwiki;jsessionid=58187C0F5A8834D07E6D7F1EB30744C2
 */

/**
 * Adapted by Benjamin BERNARD (Maison du libre Brest) <benvii at mdl29.net>, http://mdl29.net/
 * 
 * In this implementation :
 * - some bots/crawlers/readers can fetch dokuwiki pages without being redirected the CAS
 *     Thanks for adding user-agents to the pattern and reporting it to me <benvii at mdl29.net> and/or to http://www.dokuwiki.org/auth:cas
 * - debugging mode, simply put the log file location ($conf['auth']['cas']['logFile']) to enable logs, check acces rights
 * - a modified version of phpCAS library, if a new way to manage sessions.
 *     This new way of managing sessions is not currently implement in the official version. See pull request : https://github.com/Jasig/phpCAS/pull/29
 *     Sources can be found here : https://github.com/Benvii/phpCAS
 * - Trusted CAS hosts : to handle CAS logout request you need to precis a list of trusted cas hosts like this :
 *     $conf['auth']['cas']['handlelogoutrequestTrustedHosts'] = Array("cas.mdl29.net", "cas2.mdl29.net");
 */
 
require_once(DOKU_INC.'inc/auth/ldap.class.php');
include_once(DOKU_INC.'inc/phpCAS-MDL/CAS.php');

global $conf;
 
class auth_cas extends auth_ldap {
	public $cnfcas = null;
 
    function __construct() {
		global $conf;
 
        parent::__construct();
        $this->cnfcas = $conf['auth']['cas'];

        $this->cando['external'] = (preg_match("#(bot)|(slurp)|(netvibes)#i", $_SERVER['HTTP_USER_AGENT'])) ? false : true; //Disable CAS redirection for bots/crawlers/readers
        $this->cando['login'] = true;
        $this->cando['logout'] = true;

		if(!empty($this->cnfcas["logFile"])){ phpCAS::setDebug($this->cnfcas["logFile"]);} //If $conf['auth']['cas']['logFile'] exist we start phpCAS in debug mode

        phpCAS::client(CAS_VERSION_2_0, $this->cnfcas['server'], (int) $this->cnfcas['port'], $this->cnfcas['rootcas'], true); 
		//Note the last argument true, to allow phpCAS to change the session_id so he will be able to destroy the session after a CAS logout request - Enable Single Sign Out

        // curl extension is needed
        if(!function_exists('curl_init')) {
            if ($this->cnf['debug'])
                msg("CAS err: CURL extension not found.",-1,__LINE__,__FILE__);
            $this->success = false;
            return;
        }
        // automatically log the user when there is a cas session opened
        if($this->cnfcas['autologin']) {
            phpCAS::setCacheTimesForAuthRecheck(1);
        }
        else {
            phpCAS::setCacheTimesForAuthRecheck(-1);
        }
 
        if($this->cnfcas['cert']) {
            phpCAS::setCasServerCert($this->cnfcas['cert']);
        }
        elseif($this->cnfcas['cacert']) {
            phpCAS::setCasServerCACert($this->cnfcas['cacert']);
        }
        else {
            phpCAS::setNoCasServerValidation();
        }
 
        if($this->cnfcas['handlelogoutrequest']) {
            phpCAS::handleLogoutRequests(true, $conf['auth']['cas']['handlelogoutrequestTrustedHosts']);
        }
        else {
            phpCAS::handleLogoutRequests(false);
        }
   }

	public function autoLogin(){
	}
 
    public function trustExternal($user,$pass,$sticky=false) {
        global $USERINFO;
        global $conf;
 
        $sticky ? $sticky = true : $sticky = false; //sanity check
 
        $session = $_SESSION[$conf['title']]['auth'];
        if(phpCAS::checkAuthentication()) {
            $user = phpCAS::getUser();
 
            if(isset($session)) {
                $_SERVER['REMOTE_USER'] = $user;
                $USERINFO = $session['info'];
                $_SESSION[$conf['title']]['auth']['user'] = $user;
                $_SESSION[$conf['title']]['auth']['pass'] = $session['pass'];
                $_SESSION[$conf['title']]['auth']['info'] = $USERINFO;
                $_SESSION[$conf['title']]['auth']['buid'] = $session['buid'];
            }
            else {
                $USERINFO = $this->getUserData($user);
                $_SERVER['REMOTE_USER'] = $user;
                $_SESSION[$conf['title']]['auth']['user'] = $user;
                $_SESSION[$conf['title']]['auth']['pass'] = $pass;
                $_SESSION[$conf['title']]['auth']['info'] = $USERINFO;
                $_SESSION[$conf['title']]['auth']['buid'] = auth_browseruid();
            }
 
            return true;
        }
        return false;
    }
 
		public function logIn() {
			global $QUERY;
			$login_url = DOKU_URL . 'doku.php?id=' . $QUERY;
			phpCAS::setFixedServiceURL($login_url);
			phpCAS::forceAuthentication();
		}
 
    public function logOff() {
        global $QUERY;
        if($this->cnfcas['caslogout']) { // dokuwiki + cas logout
           @session_start();
            session_destroy();
			   $logout_url = DOKU_URL . 'doku.php?id=' . $QUERY;
            phpCAS::logoutWithRedirectService($logout_url);
        }
        else { // dokuwiki logout only
            @session_start();
            session_destroy();
        }
    }
}
