/******************************************************************************/
/*                                                                            */
/*     _  _ ____ _ ____ ____ _  _    ___  _  _    _    _ ___  ____ ____       */
/*     |\/| |__| | [__  |  | |\ |    |  \ |  |    |    | |__] |__/ |___       */
/*     |  | |  | | ___] |__| | \|    |__/ |__|    |___ | |__] |  \ |___       */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* Titre          : Robot Arduino avec shield L9110                           */
/*                                                                            */
/* URL            :  http://mdl29.net                                         */
/* Auteur :       :  Arnaud Reungoat                                          */
/* Contact:       :  arnuaudr@mdl29.net                                       */
/* Date édition   :  Juin 2016                                                */
/*                                                                            */
/* Licence         : GNU General Public License                               */
/******************************************************************************/
#include <NewPing.h>

// ****************************************
// Déclaration des constantes et variables
// ****************************************

// capteur de distance

#define trigPin   12  //  Pin Trigger branchée sur la broche 12 de l'arduino
#define echoPin   11  //  Pin Echo branchée sur la broche 11 de l'arduino



NewPing sonar(trigPin, echoPin);

int maximumDistance = 50;  // distance Maximale acceptée (de 0-450 cm)
int minimumDistance = 0;   // distance Minimale acceptée (en cm)
int cm = 0;


boolean PasObstacle = true;   // valeur à O ou true si pas d'obstacle détecté  sinon la valeur prend 1

const int distanceObstacle = 15; //  Distance de détection d'un obstable : ici 15 cm
int distance = 0;
int attenteCateur = 200;

// Variables pour la vitesse de chaque moteur
// Les moteurs ne tournant pas exactement à la meme vitesse, ajouter les valeurs suivantes

#define vitesse_MG  180   //vitesse moteur gauche : 255 vitesse max
#define vitesse_MD  150  // vitesse moteur droit  : 255 vitesse max

// moteur A (moteur Gauche)
int AIA = 5;    //  connecté à la broche 5 de l'arduino
int AIB = 6;    //  broche 6

// moteur B (moteur Droit)
int BIA = 9;   // connecté à la broche 9 de l'arduino
int BIB = 10;  // brochoe 10

/* Vous pouvez inverser les moteurs
le moteur gauche devient le moteur droit
En respectant bien le branchement sur la carte Arduino
*/


/***************************************************************************************************************************
La fonction setup() est appelée au démarrage du programme. Cette fonction est utilisée pour initialiser les variables,
le sens des broches, les librairies utilisées. La fonction setup n'est exécutée qu'une seule fois, après chaque mise sous
tension ou reset (réinitialisation) de la carte Arduino
****************************************************************************************************************************/

void setup()
{
  // On déclare les broches 5,6,9,10 en sortie.pour piloter les 2 moteurs
  // Moteur gauche
  pinMode(AIA, OUTPUT);
  pinMode(AIB, OUTPUT);

  // moteur droit
  pinMode(BIA, OUTPUT);
  pinMode(BIB, OUTPUT);

  // Serial.begin(9600);

  stopRobot();
  delay(300);




}

// *************************************************
// la boucle = le programme principal
// *************************************************

void loop()
{


  distance =  mesureDistance();  // on lit la valeur en cm du capteur ultrason

  delay(attenteCateur);    // Attente entre chaque mesure
  //  Serial.println( distance); // affichage la valeur sur l'écran série




  // tant qu'il n'y pas d'obstacle le robot avance
  if (PasObstacle)  {

    avanceRobot();
  }

  /******************************/
  /* si un obstacle est détecté */
  /******************************/

  else
  {
    // on arrete le robot
    stopRobot();

    delay(600);         // on stoppe pendant 400 ms

    reculeRobot();    // on recule le robot pendant 200 ms

    delay(200);    // cette valeur peut etre changée si on veut réculer plus longtemps

    // on tourne sur place pendant 200 ms
    // robotSurPlaceDroite();
    tourneDroite();

    delay(200);  // cette valeur peut etre changée si on veut reculer plus longtemps
  }

} // fin boucle principale



/*********************************************************************************************
   Les fonctions du robot :

- avanceRobot()
- reculeRobot()
- tourneDroite()
- tourneGauche()
- robotSurPlaceGauche()
- robotSurPlaceDroite()
- stopRobot()

Pour appeler une fonction dans la boucle princaple (loop) on utilise la syntaxe suivante :
avanceRobot();

On rajoute un point virgule en fin de ligne.

**********************************************************************************************/
void avanceRobot() {

  //moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  //moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);
}

void reculeRobot() {

  //moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, vitesse_MG);

  //moteur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, vitesse_MD);
}


void tourneDroite() {

  //moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  //moteur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, LOW);
}

void tourneGauche() {

  //moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, LOW);

  //moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);

}


void robotSurPlaceGauche() {

  //moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, vitesse_MG);

  //moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);

}

void robotSurPlaceDroite() {


  //moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  //moeur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, vitesse_MD);

}


void stopRobot() {

  digitalWrite(AIA, LOW);
  digitalWrite(AIB, LOW);
  digitalWrite(BIA, LOW);
  digitalWrite(BIB, LOW);
}



// Mesure la distance avec le capteur ultrason HC-SR04
unsigned int mesureDistance() {
  // déclaration des variables locales



  int  cm = sonar.ping_cm();


  if (cm > distanceObstacle || cm  <= minimumDistance) {
    PasObstacle =  true;  // on renvoie true s'il n'y pas d'obstacle
  }
  else  {
    PasObstacle = false;  // on renvoie false s'il y a un obstacle
  }

  return cm; // retourne la distance du capteur en cm

}








