/******************************************************************************/
/*                                                                            */
/*     _  _ ____ _ ____ ____ _  _    ___  _  _    _    _ ___  ____ ____       */
/*     |\/| |__| | [__  |  | |\ |    |  \ |  |    |    | |__] |__/ |___       */
/*     |  | |  | | ___] |__| | \|    |__/ |__|    |___ | |__] |  \ |___       */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* Titre          :  Robot ROSA - Robot Open Source Arduino                   */
/*                                                                            */
/* URL            :  http://mdl29.net                                         */
/* Auteur :       :  Arnaud Reungoat                                          */
/* Contact :      :  arnuaud.reungoat@openpathview.fr                         */
/* Date édition   :  Avril 2022                                               */
/*                                                                            */
/* Licence        : GNU General Public License                                */
/******************************************************************************/

// On importe la bibliothèque NewPing
#include <NewPing.h>

// ****************************************
// Déclaration des constantes et variables
// ****************************************

// On définit les broches du capteur ultrason

#define trigPin   12   //  Pin Trigger branchée sur la broche 12 de l'arduino
#define echoPin   11  //   Pin Echo branchée sur la broche 11 de l'arduino

#define maximumDistance 100  //  Le capteur a une plage de mesure de 2 cm à 400 cm - ici on bride la distance à 1m

NewPing distanceCM (trigPin, echoPin, maximumDistance);   // On initialise la fonction distanceCM 


int minimumDistance = 0;             // distance minimale acceptée (en cm)

int distanceObstacle = 20;         //  distance de détection d'un obstable : ici 20 cm

boolean PasObstacle = true;      // valeur à true (ou 1) si pas d'obstacle détecté sinon la variable passe à false (ou 0)

int attenteCapteur = 100;      // temps (en ms) entre chaque mesure du capteur (ne pas descendre en dessous de cette valeur)

// variables pour la vitesse de chaque moteur
// les moteurs ne tournent pas exactement à la même vitesse, modifiez les valeurs suivantes pour trouver la bonne vitesse

#define vitesse_MG  150   // vitesse moteur gauche  : valeur comprise entre 0 et 255 
#define vitesse_MD  150  //  vitesse moteur droit   : valeur comprise entre 0 et 255 

// moteur A (moteur Gauche)
int AIA = 5;    //  connecté à la broche 5 de l'arduino
int AIB = 6;    //  connecté à la broche 6 de l'arduino

// moteur B (moteur Droit)
int BIA = 9;   // connecté à la broche 9 de l'arduino
int BIB = 10;  // connecté à la broche 10 de l'arduino

// Vous pouvez inverser les moteurs, ainsi le moteur gauche devient le moteur droit et vice et versa


/***************************************************************************************************************************
La fonction setup() est appelée au démarrage du programme. Cette fonction est utilisée pour initialiser les variables,
définir les broches (entrée ou sortie). La fonction setup n'est exécutée qu'une seule fois, après chaque mise sous
tension ou reset (réinitialisation) de la carte Arduino.
****************************************************************************************************************************/

void setup()
{
  // On déclare les broches 5,6,9,10 en sortie pour piloter les 2 moteurs
 
  // Moteur gauche
  pinMode(AIA, OUTPUT);
  pinMode(AIB, OUTPUT);

  // moteur droit
  pinMode(BIA, OUTPUT);
  pinMode(BIB, OUTPUT);

  stopRobot();
  delay(500);  // Arrêt du robot pendant 500 ms soit une demi-seconde

}

// *************************************************
//     la boucle = le programme principal
// *************************************************

void loop()
{
   mesureDistance();  // on lit la valeur en cm du capteur de distance
 
   delay(attenteCapteur);    // Attente entre chaque mesure

  // tant qu'il n'y pas d'obstacle le robot avance tout droit

  if (PasObstacle)  {

    avanceRobot();
  }

  /******************************/
  /* si un obstacle est détecté */
  /******************************/

  else
  {
    // Arrêt du robot
    stopRobot();
    delay(300);              // On arrête le robot pendant 300 ms

    reculeRobot();        
    delay(250);           // On recule le robot pendant 250 ms (on peut modifier le temps)

    tourneDroite();     // Le robot tourne à droite pendant 250ms. 
                       // On peut aussi le faire tourner à gauche en appelant la fonction : tourneGauche();
                      // ou robotSurPlaceGauche(); et robotSurPlaceDroite();
   
   delay(250);      // cette valeur peut etre changée si on souhaite tourner plus longtemps
  }

} // fin de la  boucle principale



/*********************************************************************************************
   Les fonctions du robot :

- avanceRobot()
- reculeRobot()
- tourneDroite()
- tourneGauche()
- robotSurPlaceGauche()
- robotSurPlaceDroite()
- stopRobot()

Pour appeler une fonction dans la boucle princaple (loop) on utilise la syntaxe suivante :
avanceRobot();

On rajoute un point virgule en fin de ligne

**********************************************************************************************/

void avanceRobot() {

  //moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  //moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);
}


void reculeRobot() {

  //moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, vitesse_MG);

  //moteur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, vitesse_MD);
}


void tourneDroite() {

  //moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  //moteur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, LOW);
}


void tourneGauche() {

  //moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, LOW);

  //moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);

}


void robotSurPlaceGauche() {

  //moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, vitesse_MG);

  //moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);

}

void robotSurPlaceDroite() {


  //moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  //moeur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, vitesse_MD);

}


void stopRobot() {

  digitalWrite(AIA, LOW);
  digitalWrite(AIB, LOW);
  digitalWrite(BIA, LOW);
  digitalWrite(BIB, LOW);
}



// fonction qui retourne la distance mesurée en cm par le capteur ultrason

unsigned int mesureDistance() {

  // déclaration de la variable locale et lecture de la distance du capteur
  int  cm = distanceCM.ping_cm();

  // on définit la plage de détection du capteur
  if (cm > distanceObstacle || cm  <= minimumDistance) {
    PasObstacle =  true;   // on renvoie true s'il n'y pas d'obstacle
  }
  else  {
    PasObstacle = false;  // sinon on renvoie false
  }
  return cm;             // fonction qui retourne la distance du capteur en cm

}








