/******************************************************************************/
/*                                                                            */
/*     _  _ ____ _ ____ ____ _  _    ___  _  _    _    _ ___  ____ ____       */
/*     |\/| |__| | [__  |  | |\ |    |  \ |  |    |    | |__] |__/ |___       */
/*     |  | |  | | ___] |__| | \|    |__/ |__|    |___ | |__] |  \ |___       */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* Titre          : Robot Arduino avec shield L9110                           */
/*                                                                            */
/* URL            :  http://mdl29.net                                         */
/* Auteur :       :  Arnaud Reungoat                                          */
/* Contact:       :  arnuaudr@mdl29.net                                       */
/* Date édition   :  Juin 2016                                                */
/*                                                                            */
/* Licence         : GNU General Public License                               */
/******************************************************************************/


// Variables pour la vitesse de chaque moteur
// Les moteurs ne tournant pas exactement à la meme vitesse, ajouter les valeurs suivantes

#define vitesse_MG  180  //vitesse moteur gauche :  255 vitesse maximun
#define vitesse_MD  150  // vitesse moteur droit  : 255 vitesse maximum

// moteur A (moteur Gauche)
int AIA = 5;    //  connecté à la broche 5 de l'arduino
int AIB = 6;    //  broche 6

// moteur B (moteur Droit)
int BIA = 9;   // connecté à la broche 9 de l'arduino
int BIB = 10;  // brochoe 10

/* Vous pouvez inverser les moteurs
le moteur gauche devient le moteur droit
En respectant bien le branchement sur la carte Arduino
*/


/***************************************************************************************************************************
La fonction setup() est appelée au démarrage du programme. Cette fonction est utilisée pour initialiser les variables,
le sens des broches, les librairies utilisées. La fonction setup n'est exécutée qu'une seule fois, après chaque mise sous
tension ou reset (réinitialisation) de la carte Arduino
****************************************************************************************************************************/

void setup()
{
  // On déclare les broches 5,6,9,10 en sortie.pour piloter les 2 moteurs
  // Moteur gauche
  pinMode(AIA, OUTPUT);
  pinMode(AIB, OUTPUT);

  // moteur droit
  pinMode(BIA, OUTPUT);
  pinMode(BIB, OUTPUT);

}

// *************************************************
// la boucle = le programme principal             */
// *************************************************

void loop()
{

  /***************************************************************/
  /*     Test du sens de rotation des moteurs                    */
  /*                                                             */
  /*  On appelle la fonction avanceRobot()                       */
  /*  Ne pas oublier le point virgule en fin de ligne            */
  /*                                                             */
  /*  Si un des moteur tourne dans le mauvais sens,              */
  /*  inverser le fil noir et mauve sur le controleur moteur     */
  /*               Voir le schéma du robot                       */
  /***************************************************************/



avanceRobot();

//reculeRobot();  // décommenter la ligne si vous souhaitez que le robot recule

// la liste complètes des fonctions sont disponibles juste en dessus

} // fin boucle principale



/*********************************************************************************************
   Les fonctions du robot :

- avanceRobot()
- reculeRobot()
- tourneDroite()
- tourneGauche()
- robotSurPlaceGauche()
- robotSurPlaceDroite()
- stopRobot()

Pour appeler une fonction dans la boucle princaple (loop) on utilise la syntaxe suivante :
avanceRobot();

On rajoute un point virgule en fin de ligne.

**********************************************************************************************/

void avanceRobot() {

  // moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  // moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);
}

void reculeRobot() {

  // moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, vitesse_MG);

  // moteur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, vitesse_MD);
}


void tourneDroite() {

  // moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  // moteur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, LOW);
}

void tourneGauche() {

  // moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, LOW);

  // moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);

}


void robotSurPlaceGauche() {

  // moteur A
  analogWrite(AIA, LOW);
  analogWrite(AIB, vitesse_MG);

  // moteur B
  analogWrite(BIA, vitesse_MD);
  analogWrite(BIB, LOW);

}

void robotSurPlaceDroite() {

  // moteur A
  analogWrite(AIA, vitesse_MG);
  analogWrite(AIB, LOW);

  // moteur B
  analogWrite(BIA, LOW);
  analogWrite(BIB, vitesse_MD);

}


void stopRobot() {

  // moteur A
  digitalWrite(AIA, LOW);
  digitalWrite(AIB, LOW);

  // moteur B
  digitalWrite(BIA, LOW);
  digitalWrite(BIB, LOW);
}











